import java.awt.image.ImageObserver;
import java.awt.Graphics;
import java.util.Vector;
import java.awt.Color;

//
// Decompiled by Procyon v0.5.36
//

class Enemy extends Sprite
{
    static final int SPEED = 3;
    static final int FRAMES = 8;
    static final int ANIM_DELAY = 4;
    static final int XOFFSET = -7;
    static final int YOFFSET = -7;
    static final int LEFT = 1;
    static final int RIGHT = 2;
    static final int UP = 3;
    static final int DOWN = 4;
    static final Color COL_DRAW;
    static final Color COL_LINE;
    static final Color COL_FILL;
    int Xoffs;
    int Yoffs;
    int Xmax;
    int Ymax;
    int XSpeed;
    int YSpeed;
    int dir;
    Vector ClearList;

    private void PaintDot(final Graphics graphics, final int n, final int n2, final Color color) {
        graphics.setColor(color);
        graphics.drawLine(n + this.Xoffs, n2 + this.Yoffs, n + this.Xoffs, n2 + this.Yoffs);
    }

    public Enemy(final int xSpeed, final int ySpeed, final int xoffs, final int yoffs, final int xmax, final int ymax) {
        this.XSpeed = 1;
        this.YSpeed = 1;
        this.ClearList = new Vector();
        super.Name = "Enemy";
        this.XSpeed = xSpeed;
        this.YSpeed = ySpeed;
        this.Xoffs = xoffs;
        this.Yoffs = yoffs;
        this.Xmax = xmax;
        this.Ymax = ymax;
        super.XPos = (int)((xmax - 1) * Math.random() + 1.0);
        super.YPos = (int)((ymax - 1) * Math.random() + 1.0);
        super.Priority = 1;
        super.AnimDelay = 4;
        super.AnimCount = 0;
        super.FrameCount = 0;
        super.MaxFrames = 8;
        this.dir = 0;
        super.Visible = true;
        super.Frames = Fillit.Enemy_Frames;
    }

    public void Copy(final Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.drawLine(super.XPos + this.Xoffs, super.YPos + this.Yoffs, super.XPos + this.Xoffs, super.YPos + this.Yoffs);
        graphics.drawImage(super.Frames[super.FrameCount], super.XPos - 7 + this.Xoffs, super.YPos - 7 + this.Yoffs, null);
    }

    static {
        COL_DRAW = new Color(255, 128, 128);
        COL_LINE = new Color(128, 128, 255);
        COL_FILL = new Color(16, 32, 96);
    }

    public boolean Handler() {
        int n = 0;
        do {
            if (super.XPos + this.XSpeed < 0 || super.XPos + this.XSpeed >= Fillit.Matrix.length) {
                this.XSpeed *= -1;
                System.out.println("OOB x");
            }
            if (super.YPos + this.YSpeed < 0 || super.YPos + this.YSpeed >= Fillit.Matrix[super.XPos + this.XSpeed].length) {
                this.YSpeed *= -1;
                System.out.println("OOB y");
            }

            //System.out.println(Fillit.Matrix.length);
            //System.out.println(super.XPos + ", " + this.XSpeed);
            if (Fillit.Matrix[super.XPos + this.XSpeed][super.YPos + this.YSpeed] == 1 && Player.Destroyed == 0) {
                Player.Destroyed = 100;
            }
            if (Fillit.Matrix[super.XPos + this.XSpeed][super.YPos + this.YSpeed] == 0) {
                super.XPos += this.XSpeed;
                super.YPos += this.YSpeed;
            }
            else if (Fillit.Matrix[super.XPos + this.XSpeed][super.YPos] == 0 && Fillit.Matrix[super.XPos][super.YPos + this.YSpeed] == 0) {
                this.XSpeed *= -1;
                this.YSpeed *= -1;
            }
            else if (Fillit.Matrix[super.XPos + this.XSpeed][super.YPos] != 0) {
                this.XSpeed *= -1;
            }
            else {
                if (Fillit.Matrix[super.XPos][super.YPos + this.YSpeed] == 0) {
                    continue;
                }
                this.YSpeed *= -1;
            }
        } while (++n < 3);
        this.Animate();
        return true;
    }
}
